package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait MediaPipelineStatusUpdate {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate
}
object MediaPipelineStatusUpdate {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate
  ): zio.aws.chimesdkmediapipelines.model.MediaPipelineStatusUpdate =
    value match {
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate.PAUSE =>
        val r = Pause
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate.RESUME =>
        val r = Resume
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineStatusUpdate {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate.UNKNOWN_TO_SDK_VERSION
  }
  case object Pause
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineStatusUpdate {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate.PAUSE
  }
  case object Resume
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineStatusUpdate {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineStatusUpdate.RESUME
  }
}
