package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMediaPipelinesResponse(
    mediaPipelines: Optional[
      Iterable[zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse = {
    import ListMediaPipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse
      .builder()
      .optionallyWith(
        mediaPipelines.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaPipelines)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse
      .wrap(buildAwsValue())
}
object ListMediaPipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse =
      zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse(
        mediaPipelines.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def mediaPipelines: Optional[
      List[zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getMediaPipelines: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("mediaPipelines", mediaPipelines)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse
  ) extends zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse.ReadOnly {
    override val mediaPipelines: Optional[
      List[zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaPipelines())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse
  ): zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse.ReadOnly =
    new Wrapper(impl)
}
