package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.GuidString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteMediaCapturePipelineRequest(
    mediaPipelineId: GuidString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest = {
    import DeleteMediaCapturePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest
      .builder()
      .mediaPipelineId(GuidString.unwrap(mediaPipelineId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest
      .wrap(buildAwsValue())
}
object DeleteMediaCapturePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest =
      zio.aws.chimesdkmediapipelines.model
        .DeleteMediaCapturePipelineRequest(mediaPipelineId)
    def mediaPipelineId: GuidString
    def getMediaPipelineId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(mediaPipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest
  ) extends zio.aws.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest.ReadOnly {
    override val mediaPipelineId: GuidString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .GuidString(impl.mediaPipelineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest
  ): zio.aws.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
