package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  AudioSampleRateOption,
  SensitiveString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LiveConnectorRTMPConfiguration(
    url: SensitiveString,
    audioChannels: Optional[
      zio.aws.chimesdkmediapipelines.model.AudioChannelsOption
    ] = Optional.Absent,
    audioSampleRate: Optional[AudioSampleRateOption] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration = {
    import LiveConnectorRTMPConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration
      .builder()
      .url(SensitiveString.unwrap(url): java.lang.String)
      .optionallyWith(audioChannels.map(value => value.unwrap))(_.audioChannels)
      .optionallyWith(
        audioSampleRate.map(value =>
          AudioSampleRateOption.unwrap(value): java.lang.String
        )
      )(_.audioSampleRate)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration
      .wrap(buildAwsValue())
}
object LiveConnectorRTMPConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration =
      zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration(
        url,
        audioChannels.map(value => value),
        audioSampleRate.map(value => value)
      )
    def url: SensitiveString
    def audioChannels
        : Optional[zio.aws.chimesdkmediapipelines.model.AudioChannelsOption]
    def audioSampleRate: Optional[AudioSampleRateOption]
    def getUrl: ZIO[Any, Nothing, SensitiveString] = ZIO.succeed(url)
    def getAudioChannels: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.AudioChannelsOption
    ] = AwsError.unwrapOptionField("audioChannels", audioChannels)
    def getAudioSampleRate: ZIO[Any, AwsError, AudioSampleRateOption] =
      AwsError.unwrapOptionField("audioSampleRate", audioSampleRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration.ReadOnly {
    override val url: SensitiveString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .SensitiveString(impl.url())
    override val audioChannels
        : Optional[zio.aws.chimesdkmediapipelines.model.AudioChannelsOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audioChannels())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.AudioChannelsOption.wrap(value)
        )
    override val audioSampleRate: Optional[AudioSampleRateOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audioSampleRate())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .AudioSampleRateOption(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration
  ): zio.aws.chimesdkmediapipelines.model.LiveConnectorRTMPConfiguration.ReadOnly =
    new Wrapper(impl)
}
