package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateMediaInsightsPipelineStatusRequest(
    identifier: NonEmptyString,
    updateStatus: zio.aws.chimesdkmediapipelines.model.MediaPipelineStatusUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest = {
    import UpdateMediaInsightsPipelineStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .updateStatus(updateStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest
      .wrap(buildAwsValue())
}
object UpdateMediaInsightsPipelineStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest =
      zio.aws.chimesdkmediapipelines.model
        .UpdateMediaInsightsPipelineStatusRequest(identifier, updateStatus)
    def identifier: NonEmptyString
    def updateStatus
        : zio.aws.chimesdkmediapipelines.model.MediaPipelineStatusUpdate
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
    def getUpdateStatus: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineStatusUpdate
    ] = ZIO.succeed(updateStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest
  ) extends zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
    override val updateStatus
        : zio.aws.chimesdkmediapipelines.model.MediaPipelineStatusUpdate =
      zio.aws.chimesdkmediapipelines.model.MediaPipelineStatusUpdate
        .wrap(impl.updateStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest
  ): zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest.ReadOnly =
    new Wrapper(impl)
}
