package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RealTimeAlertRule(
    `type`: zio.aws.chimesdkmediapipelines.model.RealTimeAlertRuleType,
    keywordMatchConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration
    ] = Optional.Absent,
    sentimentConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SentimentConfiguration
    ] = Optional.Absent,
    issueDetectionConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.IssueDetectionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRule = {
    import RealTimeAlertRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRule
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        keywordMatchConfiguration.map(value => value.buildAwsValue())
      )(_.keywordMatchConfiguration)
      .optionallyWith(
        sentimentConfiguration.map(value => value.buildAwsValue())
      )(_.sentimentConfiguration)
      .optionallyWith(
        issueDetectionConfiguration.map(value => value.buildAwsValue())
      )(_.issueDetectionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule.wrap(buildAwsValue())
}
object RealTimeAlertRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule =
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule(
        `type`,
        keywordMatchConfiguration.map(value => value.asEditable),
        sentimentConfiguration.map(value => value.asEditable),
        issueDetectionConfiguration.map(value => value.asEditable)
      )
    def `type`: zio.aws.chimesdkmediapipelines.model.RealTimeAlertRuleType
    def keywordMatchConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration.ReadOnly
    ]
    def sentimentConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SentimentConfiguration.ReadOnly
    ]
    def issueDetectionConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.IssueDetectionConfiguration.ReadOnly
    ]
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertRuleType
    ] = ZIO.succeed(`type`)
    def getKeywordMatchConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "keywordMatchConfiguration",
      keywordMatchConfiguration
    )
    def getSentimentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.SentimentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sentimentConfiguration",
      sentimentConfiguration
    )
    def getIssueDetectionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.IssueDetectionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "issueDetectionConfiguration",
      issueDetectionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRule
  ) extends zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule.ReadOnly {
    override val `type`
        : zio.aws.chimesdkmediapipelines.model.RealTimeAlertRuleType =
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertRuleType
        .wrap(impl.`type`())
    override val keywordMatchConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.keywordMatchConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration
          .wrap(value)
      )
    override val sentimentConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SentimentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sentimentConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.SentimentConfiguration.wrap(value)
      )
    override val issueDetectionConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.IssueDetectionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.issueDetectionConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.IssueDetectionConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRule
  ): zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule.ReadOnly =
    new Wrapper(impl)
}
