package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  CategoryName,
  VocabularyName,
  VocabularyFilterName,
  ModelName,
  PiiEntityTypes
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AmazonTranscribeCallAnalyticsProcessorConfiguration(
    languageCode: zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode,
    vocabularyName: Optional[VocabularyName] = Optional.Absent,
    vocabularyFilterName: Optional[VocabularyFilterName] = Optional.Absent,
    vocabularyFilterMethod: Optional[
      zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod
    ] = Optional.Absent,
    languageModelName: Optional[ModelName] = Optional.Absent,
    enablePartialResultsStabilization: Optional[Boolean] = Optional.Absent,
    partialResultsStability: Optional[
      zio.aws.chimesdkmediapipelines.model.PartialResultsStability
    ] = Optional.Absent,
    contentIdentificationType: Optional[
      zio.aws.chimesdkmediapipelines.model.ContentType
    ] = Optional.Absent,
    contentRedactionType: Optional[
      zio.aws.chimesdkmediapipelines.model.ContentType
    ] = Optional.Absent,
    piiEntityTypes: Optional[PiiEntityTypes] = Optional.Absent,
    filterPartialResults: Optional[Boolean] = Optional.Absent,
    postCallAnalyticsSettings: Optional[
      zio.aws.chimesdkmediapipelines.model.PostCallAnalyticsSettings
    ] = Optional.Absent,
    callAnalyticsStreamCategories: Optional[Iterable[CategoryName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration = {
    import AmazonTranscribeCallAnalyticsProcessorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration
      .builder()
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        vocabularyName.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.vocabularyName)
      .optionallyWith(
        vocabularyFilterName.map(value =>
          VocabularyFilterName.unwrap(value): java.lang.String
        )
      )(_.vocabularyFilterName)
      .optionallyWith(vocabularyFilterMethod.map(value => value.unwrap))(
        _.vocabularyFilterMethod
      )
      .optionallyWith(
        languageModelName.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.languageModelName)
      .optionallyWith(
        enablePartialResultsStabilization.map(value => value: java.lang.Boolean)
      )(_.enablePartialResultsStabilization)
      .optionallyWith(partialResultsStability.map(value => value.unwrap))(
        _.partialResultsStability
      )
      .optionallyWith(contentIdentificationType.map(value => value.unwrap))(
        _.contentIdentificationType
      )
      .optionallyWith(contentRedactionType.map(value => value.unwrap))(
        _.contentRedactionType
      )
      .optionallyWith(
        piiEntityTypes.map(value =>
          PiiEntityTypes.unwrap(value): java.lang.String
        )
      )(_.piiEntityTypes)
      .optionallyWith(
        filterPartialResults.map(value => value: java.lang.Boolean)
      )(_.filterPartialResults)
      .optionallyWith(
        postCallAnalyticsSettings.map(value => value.buildAwsValue())
      )(_.postCallAnalyticsSettings)
      .optionallyWith(
        callAnalyticsStreamCategories.map(value =>
          value.map { item =>
            CategoryName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.callAnalyticsStreamCategories)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration
      .wrap(buildAwsValue())
}
object AmazonTranscribeCallAnalyticsProcessorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .AmazonTranscribeCallAnalyticsProcessorConfiguration(
          languageCode,
          vocabularyName.map(value => value),
          vocabularyFilterName.map(value => value),
          vocabularyFilterMethod.map(value => value),
          languageModelName.map(value => value),
          enablePartialResultsStabilization.map(value => value),
          partialResultsStability.map(value => value),
          contentIdentificationType.map(value => value),
          contentRedactionType.map(value => value),
          piiEntityTypes.map(value => value),
          filterPartialResults.map(value => value),
          postCallAnalyticsSettings.map(value => value.asEditable),
          callAnalyticsStreamCategories.map(value => value)
        )
    def languageCode
        : zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    def vocabularyName: Optional[VocabularyName]
    def vocabularyFilterName: Optional[VocabularyFilterName]
    def vocabularyFilterMethod
        : Optional[zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod]
    def languageModelName: Optional[ModelName]
    def enablePartialResultsStabilization: Optional[Boolean]
    def partialResultsStability
        : Optional[zio.aws.chimesdkmediapipelines.model.PartialResultsStability]
    def contentIdentificationType
        : Optional[zio.aws.chimesdkmediapipelines.model.ContentType]
    def contentRedactionType
        : Optional[zio.aws.chimesdkmediapipelines.model.ContentType]
    def piiEntityTypes: Optional[PiiEntityTypes]
    def filterPartialResults: Optional[Boolean]
    def postCallAnalyticsSettings: Optional[
      zio.aws.chimesdkmediapipelines.model.PostCallAnalyticsSettings.ReadOnly
    ]
    def callAnalyticsStreamCategories: Optional[List[CategoryName]]
    def getLanguageCode: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
    ] = ZIO.succeed(languageCode)
    def getVocabularyName: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("vocabularyName", vocabularyName)
    def getVocabularyFilterName: ZIO[Any, AwsError, VocabularyFilterName] =
      AwsError.unwrapOptionField("vocabularyFilterName", vocabularyFilterName)
    def getVocabularyFilterMethod: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod
    ] = AwsError.unwrapOptionField(
      "vocabularyFilterMethod",
      vocabularyFilterMethod
    )
    def getLanguageModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("languageModelName", languageModelName)
    def getEnablePartialResultsStabilization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enablePartialResultsStabilization",
        enablePartialResultsStabilization
      )
    def getPartialResultsStability: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.PartialResultsStability
    ] = AwsError.unwrapOptionField(
      "partialResultsStability",
      partialResultsStability
    )
    def getContentIdentificationType
        : ZIO[Any, AwsError, zio.aws.chimesdkmediapipelines.model.ContentType] =
      AwsError.unwrapOptionField(
        "contentIdentificationType",
        contentIdentificationType
      )
    def getContentRedactionType
        : ZIO[Any, AwsError, zio.aws.chimesdkmediapipelines.model.ContentType] =
      AwsError.unwrapOptionField("contentRedactionType", contentRedactionType)
    def getPiiEntityTypes: ZIO[Any, AwsError, PiiEntityTypes] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
    def getFilterPartialResults: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("filterPartialResults", filterPartialResults)
    def getPostCallAnalyticsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.PostCallAnalyticsSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "postCallAnalyticsSettings",
      postCallAnalyticsSettings
    )
    def getCallAnalyticsStreamCategories
        : ZIO[Any, AwsError, List[CategoryName]] = AwsError.unwrapOptionField(
      "callAnalyticsStreamCategories",
      callAnalyticsStreamCategories
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration.ReadOnly {
    override val languageCode
        : zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode =
      zio.aws.chimesdkmediapipelines.model.CallAnalyticsLanguageCode
        .wrap(impl.languageCode())
    override val vocabularyName: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyName())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.VocabularyName(value)
        )
    override val vocabularyFilterName: Optional[VocabularyFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vocabularyFilterName())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .VocabularyFilterName(value)
        )
    override val vocabularyFilterMethod: Optional[
      zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vocabularyFilterMethod())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.VocabularyFilterMethod.wrap(value)
      )
    override val languageModelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.languageModelName())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.primitives.ModelName(value)
      )
    override val enablePartialResultsStabilization: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePartialResultsStabilization())
        .map(value => value: Boolean)
    override val partialResultsStability: Optional[
      zio.aws.chimesdkmediapipelines.model.PartialResultsStability
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.partialResultsStability())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.PartialResultsStability.wrap(value)
      )
    override val contentIdentificationType
        : Optional[zio.aws.chimesdkmediapipelines.model.ContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentIdentificationType())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.ContentType.wrap(value)
        )
    override val contentRedactionType
        : Optional[zio.aws.chimesdkmediapipelines.model.ContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRedactionType())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.ContentType.wrap(value)
        )
    override val piiEntityTypes: Optional[PiiEntityTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.piiEntityTypes())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.PiiEntityTypes(value)
        )
    override val filterPartialResults: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.filterPartialResults())
      .map(value => value: Boolean)
    override val postCallAnalyticsSettings: Optional[
      zio.aws.chimesdkmediapipelines.model.PostCallAnalyticsSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.postCallAnalyticsSettings())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.PostCallAnalyticsSettings
          .wrap(value)
      )
    override val callAnalyticsStreamCategories: Optional[List[CategoryName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAnalyticsStreamCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmediapipelines.model.primitives.CategoryName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration
  ): zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration.ReadOnly =
    new Wrapper(impl)
}
