package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SqsQueueSinkConfiguration(
    insightsTarget: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.SqsQueueSinkConfiguration = {
    import SqsQueueSinkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SqsQueueSinkConfiguration
      .builder()
      .optionallyWith(
        insightsTarget.map(value => Arn.unwrap(value): java.lang.String)
      )(_.insightsTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration
      .wrap(buildAwsValue())
}
object SqsQueueSinkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SqsQueueSinkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .SqsQueueSinkConfiguration(insightsTarget.map(value => value))
    def insightsTarget: Optional[Arn]
    def getInsightsTarget: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("insightsTarget", insightsTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SqsQueueSinkConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration.ReadOnly {
    override val insightsTarget: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.insightsTarget())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SqsQueueSinkConfiguration
  ): zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration.ReadOnly =
    new Wrapper(impl)
}
