package zio.aws.chimesdkmediapipelines
import zio.prelude.Subtype
import zio.aws.chimesdkmediapipelines.model.primitives.{
  Keyword,
  ExternalUserIdType,
  GuidString,
  CategoryName,
  NonEmptyString,
  TagKey
}
import java.time.Instant
import zio.aws.chimesdkmediapipelines.model.primitives.KinesisVideoStreamArn.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.chimesdkmediapipelines.model.primitives.AmazonResourceName.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.chimesdkmediapipelines.model.primitives.Arn.Type
    object AudioSampleRateOption extends Subtype[String]
    type AudioSampleRateOption =
      zio.aws.chimesdkmediapipelines.model.primitives.AudioSampleRateOption.Type
    object CategoryName extends Subtype[String]
    type CategoryName =
      zio.aws.chimesdkmediapipelines.model.primitives.CategoryName.Type
    object ChannelId extends Subtype[Int]
    type ChannelId =
      zio.aws.chimesdkmediapipelines.model.primitives.ChannelId.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.chimesdkmediapipelines.model.primitives.ClientRequestToken.Type
    object ExternalUserIdType extends Subtype[String]
    type ExternalUserIdType =
      zio.aws.chimesdkmediapipelines.model.primitives.ExternalUserIdType.Type
    object FragmentNumberString extends Subtype[String]
    type FragmentNumberString =
      zio.aws.chimesdkmediapipelines.model.primitives.FragmentNumberString.Type
    object GuidString extends Subtype[String]
    type GuidString =
      zio.aws.chimesdkmediapipelines.model.primitives.GuidString.Type
    object Iso8601Timestamp extends Subtype[Instant]
    type Iso8601Timestamp =
      zio.aws.chimesdkmediapipelines.model.primitives.Iso8601Timestamp.Type
    object Keyword extends Subtype[String]
    type Keyword = zio.aws.chimesdkmediapipelines.model.primitives.Keyword.Type
    object KinesisVideoStreamArn extends Subtype[String]
    type KinesisVideoStreamArn =
      zio.aws.chimesdkmediapipelines.model.primitives.KinesisVideoStreamArn.Type
    object MediaInsightsPipelineConfigurationNameString extends Subtype[String]
    type MediaInsightsPipelineConfigurationNameString =
      zio.aws.chimesdkmediapipelines.model.primitives.MediaInsightsPipelineConfigurationNameString.Type
    object MediaSampleRateHertz extends Subtype[Int]
    type MediaSampleRateHertz =
      zio.aws.chimesdkmediapipelines.model.primitives.MediaSampleRateHertz.Type
    object ModelName extends Subtype[String]
    type ModelName =
      zio.aws.chimesdkmediapipelines.model.primitives.ModelName.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives.NonEmptyString.Type
    object NumberOfChannels extends Subtype[Int]
    type NumberOfChannels =
      zio.aws.chimesdkmediapipelines.model.primitives.NumberOfChannels.Type
    object PiiEntityTypes extends Subtype[String]
    type PiiEntityTypes =
      zio.aws.chimesdkmediapipelines.model.primitives.PiiEntityTypes.Type
    object ResultMax extends Subtype[Int]
    type ResultMax =
      zio.aws.chimesdkmediapipelines.model.primitives.ResultMax.Type
    object RuleName extends Subtype[String]
    type RuleName =
      zio.aws.chimesdkmediapipelines.model.primitives.RuleName.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString =
      zio.aws.chimesdkmediapipelines.model.primitives.SensitiveString.Type
    object SentimentTimePeriodInSeconds extends Subtype[Int]
    type SentimentTimePeriodInSeconds =
      zio.aws.chimesdkmediapipelines.model.primitives.SentimentTimePeriodInSeconds.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.chimesdkmediapipelines.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue =
      zio.aws.chimesdkmediapipelines.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp =
      zio.aws.chimesdkmediapipelines.model.primitives.Timestamp.Type
    object VocabularyFilterName extends Subtype[String]
    type VocabularyFilterName =
      zio.aws.chimesdkmediapipelines.model.primitives.VocabularyFilterName.Type
    object VocabularyName extends Subtype[String]
    type VocabularyName =
      zio.aws.chimesdkmediapipelines.model.primitives.VocabularyName.Type
  }
  type AttendeeIdList = List[GuidString]
  type CategoryNameList = List[CategoryName]
  type ChannelDefinitions =
    List[zio.aws.chimesdkmediapipelines.model.ChannelDefinition]
  type ConcatenationSinkList =
    List[zio.aws.chimesdkmediapipelines.model.ConcatenationSink]
  type ConcatenationSourceList =
    List[zio.aws.chimesdkmediapipelines.model.ConcatenationSource]
  type ExternalUserIdList = List[ExternalUserIdType]
  type KeywordMatchWordList = List[Keyword]
  type LiveConnectorSinkList =
    List[zio.aws.chimesdkmediapipelines.model.LiveConnectorSinkConfiguration]
  type LiveConnectorSourceList =
    List[zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceConfiguration]
  type MediaCapturePipelineSummaryList =
    List[zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary]
  type MediaInsightsPipelineConfigurationElements = List[
    zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
  ]
  type MediaInsightsPipelineConfigurationSummaryList = List[
    zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary
  ]
  type MediaInsightsRuntimeMetadata = Map[NonEmptyString, String]
  type MediaPipelineList =
    List[zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary]
  type RealTimeAlertRuleList =
    List[zio.aws.chimesdkmediapipelines.model.RealTimeAlertRule]
  type RecordingStreamList =
    List[zio.aws.chimesdkmediapipelines.model.RecordingStreamConfiguration]
  type Streams = List[zio.aws.chimesdkmediapipelines.model.StreamConfiguration]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.chimesdkmediapipelines.model.Tag]
}
