package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait LiveConnectorMuxType {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType
}
object LiveConnectorMuxType {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType
  ): zio.aws.chimesdkmediapipelines.model.LiveConnectorMuxType = value match {
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType.AUDIO_WITH_COMPOSITED_VIDEO =>
      val r = AudioWithCompositedVideo
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType.AUDIO_WITH_ACTIVE_SPEAKER_VIDEO =>
      val r = AudioWithActiveSpeakerVideo
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.LiveConnectorMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType.UNKNOWN_TO_SDK_VERSION
  }
  case object AudioWithCompositedVideo
      extends zio.aws.chimesdkmediapipelines.model.LiveConnectorMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType.AUDIO_WITH_COMPOSITED_VIDEO
  }
  case object AudioWithActiveSpeakerVideo
      extends zio.aws.chimesdkmediapipelines.model.LiveConnectorMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorMuxType.AUDIO_WITH_ACTIVE_SPEAKER_VIDEO
  }
}
