package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait MediaPipelineTaskStatus {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus
}
object MediaPipelineTaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus
  ): zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus =
    value match {
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.NOT_STARTED =>
        val r = NotStarted
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.INITIALIZING =>
        val r = Initializing
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.IN_PROGRESS =>
        val r = InProgress
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.FAILED =>
        val r = Failed
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.STOPPING =>
        val r = Stopping
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.STOPPED =>
        val r = Stopped
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NotStarted
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.NOT_STARTED
  }
  case object Initializing
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.INITIALIZING
  }
  case object InProgress
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.IN_PROGRESS
  }
  case object Failed
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.FAILED
  }
  case object Stopping
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.STOPPING
  }
  case object Stopped
      extends zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus.STOPPED
  }
}
