package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionSinkConfiguration(
    insightsTarget: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration = {
    import LambdaFunctionSinkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration
      .builder()
      .optionallyWith(
        insightsTarget.map(value => Arn.unwrap(value): java.lang.String)
      )(_.insightsTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration
      .wrap(buildAwsValue())
}
object LambdaFunctionSinkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .LambdaFunctionSinkConfiguration(insightsTarget.map(value => value))
    def insightsTarget: Optional[Arn]
    def getInsightsTarget: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("insightsTarget", insightsTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration.ReadOnly {
    override val insightsTarget: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.insightsTarget())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration
  ): zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration.ReadOnly =
    new Wrapper(impl)
}
