package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  Arn,
  KinesisVideoStreamPoolId,
  KinesisVideoStreamPoolName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KinesisVideoStreamPoolSummary(
    poolName: Optional[KinesisVideoStreamPoolName] = Optional.Absent,
    poolId: Optional[KinesisVideoStreamPoolId] = Optional.Absent,
    poolArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary = {
    import KinesisVideoStreamPoolSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary
      .builder()
      .optionallyWith(
        poolName.map(value =>
          KinesisVideoStreamPoolName.unwrap(value): java.lang.String
        )
      )(_.poolName)
      .optionallyWith(
        poolId.map(value =>
          KinesisVideoStreamPoolId.unwrap(value): java.lang.String
        )
      )(_.poolId)
      .optionallyWith(
        poolArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.poolArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary
      .wrap(buildAwsValue())
}
object KinesisVideoStreamPoolSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary =
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary(
        poolName.map(value => value),
        poolId.map(value => value),
        poolArn.map(value => value)
      )
    def poolName: Optional[KinesisVideoStreamPoolName]
    def poolId: Optional[KinesisVideoStreamPoolId]
    def poolArn: Optional[Arn]
    def getPoolName: ZIO[Any, AwsError, KinesisVideoStreamPoolName] =
      AwsError.unwrapOptionField("poolName", poolName)
    def getPoolId: ZIO[Any, AwsError, KinesisVideoStreamPoolId] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getPoolArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("poolArn", poolArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary
  ) extends zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary.ReadOnly {
    override val poolName: Optional[KinesisVideoStreamPoolName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.poolName())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .KinesisVideoStreamPoolName(value)
        )
    override val poolId: Optional[KinesisVideoStreamPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.poolId())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .KinesisVideoStreamPoolId(value)
        )
    override val poolArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.poolArn())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary
  ): zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamPoolSummary.ReadOnly =
    new Wrapper(impl)
}
