package zio.aws.chimesdkmediapipelines.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.NumberOfChannels
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StreamChannelDefinition(
    numberOfChannels: NumberOfChannels,
    channelDefinitions: Optional[
      Iterable[zio.aws.chimesdkmediapipelines.model.ChannelDefinition]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamChannelDefinition = {
    import StreamChannelDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamChannelDefinition
      .builder()
      .numberOfChannels(NumberOfChannels.unwrap(numberOfChannels): Integer)
      .optionallyWith(
        channelDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channelDefinitions)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition
      .wrap(buildAwsValue())
}
object StreamChannelDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamChannelDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition =
      zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition(
        numberOfChannels,
        channelDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def numberOfChannels: NumberOfChannels
    def channelDefinitions: Optional[
      List[zio.aws.chimesdkmediapipelines.model.ChannelDefinition.ReadOnly]
    ]
    def getNumberOfChannels: ZIO[Any, Nothing, NumberOfChannels] =
      ZIO.succeed(numberOfChannels)
    def getChannelDefinitions: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.ChannelDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("channelDefinitions", channelDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamChannelDefinition
  ) extends zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition.ReadOnly {
    override val numberOfChannels: NumberOfChannels =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NumberOfChannels(impl.numberOfChannels())
    override val channelDefinitions: Optional[
      List[zio.aws.chimesdkmediapipelines.model.ChannelDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.channelDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.ChannelDefinition.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamChannelDefinition
  ): zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition.ReadOnly =
    new Wrapper(impl)
}
