package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSpeakerSearchTaskResponse(
    speakerSearchTask: Optional[
      zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse = {
    import GetSpeakerSearchTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse
      .builder()
      .optionallyWith(speakerSearchTask.map(value => value.buildAwsValue()))(
        _.speakerSearchTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse
      .wrap(buildAwsValue())
}
object GetSpeakerSearchTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse =
      zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse(
        speakerSearchTask.map(value => value.asEditable)
      )
    def speakerSearchTask: Optional[
      zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.ReadOnly
    ]
    def getSpeakerSearchTask: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.ReadOnly
    ] = AwsError.unwrapOptionField("speakerSearchTask", speakerSearchTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse
  ) extends zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse.ReadOnly {
    override val speakerSearchTask: Optional[
      zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.speakerSearchTask())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.SpeakerSearchTask.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse
  ): zio.aws.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse.ReadOnly =
    new Wrapper(impl)
}
