package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActiveSpeakerOnlyConfiguration(
    activeSpeakerPosition: Optional[
      zio.aws.chimesdkmediapipelines.model.ActiveSpeakerPosition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration = {
    import ActiveSpeakerOnlyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration
      .builder()
      .optionallyWith(activeSpeakerPosition.map(value => value.unwrap))(
        _.activeSpeakerPosition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration
      .wrap(buildAwsValue())
}
object ActiveSpeakerOnlyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration =
      zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration(
        activeSpeakerPosition.map(value => value)
      )
    def activeSpeakerPosition
        : Optional[zio.aws.chimesdkmediapipelines.model.ActiveSpeakerPosition]
    def getActiveSpeakerPosition: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ActiveSpeakerPosition
    ] =
      AwsError.unwrapOptionField("activeSpeakerPosition", activeSpeakerPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration.ReadOnly {
    override val activeSpeakerPosition
        : Optional[zio.aws.chimesdkmediapipelines.model.ActiveSpeakerPosition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeSpeakerPosition())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.ActiveSpeakerPosition.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration
  ): zio.aws.chimesdkmediapipelines.model.ActiveSpeakerOnlyConfiguration.ReadOnly =
    new Wrapper(impl)
}
