package zio.aws.chimesdkmediapipelines.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  BorderThickness,
  CornerRadius
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class VideoAttribute(
    cornerRadius: Optional[CornerRadius] = Optional.Absent,
    borderColor: Optional[zio.aws.chimesdkmediapipelines.model.BorderColor] =
      Optional.Absent,
    highlightColor: Optional[
      zio.aws.chimesdkmediapipelines.model.HighlightColor
    ] = Optional.Absent,
    borderThickness: Optional[BorderThickness] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoAttribute = {
    import VideoAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoAttribute
      .builder()
      .optionallyWith(
        cornerRadius.map(value => CornerRadius.unwrap(value): Integer)
      )(_.cornerRadius)
      .optionallyWith(borderColor.map(value => value.unwrap))(_.borderColor)
      .optionallyWith(highlightColor.map(value => value.unwrap))(
        _.highlightColor
      )
      .optionallyWith(
        borderThickness.map(value => BorderThickness.unwrap(value): Integer)
      )(_.borderThickness)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmediapipelines.model.VideoAttribute.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.VideoAttribute.wrap(buildAwsValue())
}
object VideoAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.VideoAttribute =
      zio.aws.chimesdkmediapipelines.model.VideoAttribute(
        cornerRadius.map(value => value),
        borderColor.map(value => value),
        highlightColor.map(value => value),
        borderThickness.map(value => value)
      )
    def cornerRadius: Optional[CornerRadius]
    def borderColor: Optional[zio.aws.chimesdkmediapipelines.model.BorderColor]
    def highlightColor
        : Optional[zio.aws.chimesdkmediapipelines.model.HighlightColor]
    def borderThickness: Optional[BorderThickness]
    def getCornerRadius: ZIO[Any, AwsError, CornerRadius] =
      AwsError.unwrapOptionField("cornerRadius", cornerRadius)
    def getBorderColor
        : ZIO[Any, AwsError, zio.aws.chimesdkmediapipelines.model.BorderColor] =
      AwsError.unwrapOptionField("borderColor", borderColor)
    def getHighlightColor: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.HighlightColor
    ] = AwsError.unwrapOptionField("highlightColor", highlightColor)
    def getBorderThickness: ZIO[Any, AwsError, BorderThickness] =
      AwsError.unwrapOptionField("borderThickness", borderThickness)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoAttribute
  ) extends zio.aws.chimesdkmediapipelines.model.VideoAttribute.ReadOnly {
    override val cornerRadius: Optional[CornerRadius] = zio.aws.core.internal
      .optionalFromNullable(impl.cornerRadius())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.primitives.CornerRadius(value)
      )
    override val borderColor
        : Optional[zio.aws.chimesdkmediapipelines.model.BorderColor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.borderColor())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.BorderColor.wrap(value)
        )
    override val highlightColor
        : Optional[zio.aws.chimesdkmediapipelines.model.HighlightColor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.highlightColor())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.HighlightColor.wrap(value)
        )
    override val borderThickness: Optional[BorderThickness] =
      zio.aws.core.internal
        .optionalFromNullable(impl.borderThickness())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.BorderThickness(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VideoAttribute
  ): zio.aws.chimesdkmediapipelines.model.VideoAttribute.ReadOnly = new Wrapper(
    impl
  )
}
