package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  FragmentNumberString,
  KinesisVideoStreamArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StreamConfiguration(
    streamArn: KinesisVideoStreamArn,
    fragmentNumber: Optional[FragmentNumberString] = Optional.Absent,
    streamChannelDefinition: zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration = {
    import StreamConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration
      .builder()
      .streamArn(KinesisVideoStreamArn.unwrap(streamArn): java.lang.String)
      .optionallyWith(
        fragmentNumber.map(value =>
          FragmentNumberString.unwrap(value): java.lang.String
        )
      )(_.fragmentNumber)
      .streamChannelDefinition(streamChannelDefinition.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.StreamConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.StreamConfiguration
      .wrap(buildAwsValue())
}
object StreamConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.StreamConfiguration =
      zio.aws.chimesdkmediapipelines.model.StreamConfiguration(
        streamArn,
        fragmentNumber.map(value => value),
        streamChannelDefinition.asEditable
      )
    def streamArn: KinesisVideoStreamArn
    def fragmentNumber: Optional[FragmentNumberString]
    def streamChannelDefinition
        : zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition.ReadOnly
    def getStreamArn: ZIO[Any, Nothing, KinesisVideoStreamArn] =
      ZIO.succeed(streamArn)
    def getFragmentNumber: ZIO[Any, AwsError, FragmentNumberString] =
      AwsError.unwrapOptionField("fragmentNumber", fragmentNumber)
    def getStreamChannelDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition.ReadOnly
    ] = ZIO.succeed(streamChannelDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.StreamConfiguration.ReadOnly {
    override val streamArn: KinesisVideoStreamArn =
      zio.aws.chimesdkmediapipelines.model.primitives
        .KinesisVideoStreamArn(impl.streamArn())
    override val fragmentNumber: Optional[FragmentNumberString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fragmentNumber())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .FragmentNumberString(value)
        )
    override val streamChannelDefinition
        : zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.StreamChannelDefinition
        .wrap(impl.streamChannelDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration
  ): zio.aws.chimesdkmediapipelines.model.StreamConfiguration.ReadOnly =
    new Wrapper(impl)
}
