package zio.aws.chimesdkmediapipelines.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  Iso8601Timestamp,
  GuidString,
  Arn,
  MediaInsightsPipelineConfigurationNameString
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MediaInsightsPipelineConfiguration(
    mediaInsightsPipelineConfigurationName: Optional[
      MediaInsightsPipelineConfigurationNameString
    ] = Optional.Absent,
    mediaInsightsPipelineConfigurationArn: Optional[Arn] = Optional.Absent,
    resourceAccessRoleArn: Optional[Arn] = Optional.Absent,
    realTimeAlertConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration
    ] = Optional.Absent,
    elements: Optional[Iterable[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
    ]] = Optional.Absent,
    mediaInsightsPipelineConfigurationId: Optional[GuidString] =
      Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration = {
    import MediaInsightsPipelineConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration
      .builder()
      .optionallyWith(
        mediaInsightsPipelineConfigurationName.map(value =>
          MediaInsightsPipelineConfigurationNameString.unwrap(
            value
          ): java.lang.String
        )
      )(_.mediaInsightsPipelineConfigurationName)
      .optionallyWith(
        mediaInsightsPipelineConfigurationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.mediaInsightsPipelineConfigurationArn)
      .optionallyWith(
        resourceAccessRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceAccessRoleArn)
      .optionallyWith(
        realTimeAlertConfiguration.map(value => value.buildAwsValue())
      )(_.realTimeAlertConfiguration)
      .optionallyWith(
        elements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elements)
      .optionallyWith(
        mediaInsightsPipelineConfigurationId.map(value =>
          GuidString.unwrap(value): java.lang.String
        )
      )(_.mediaInsightsPipelineConfigurationId)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration
      .wrap(buildAwsValue())
}
object MediaInsightsPipelineConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration =
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration(
        mediaInsightsPipelineConfigurationName.map(value => value),
        mediaInsightsPipelineConfigurationArn.map(value => value),
        resourceAccessRoleArn.map(value => value),
        realTimeAlertConfiguration.map(value => value.asEditable),
        elements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mediaInsightsPipelineConfigurationId.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def mediaInsightsPipelineConfigurationName
        : Optional[MediaInsightsPipelineConfigurationNameString]
    def mediaInsightsPipelineConfigurationArn: Optional[Arn]
    def resourceAccessRoleArn: Optional[Arn]
    def realTimeAlertConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly
    ]
    def elements: Optional[List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly
    ]]
    def mediaInsightsPipelineConfigurationId: Optional[GuidString]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getMediaInsightsPipelineConfigurationName
        : ZIO[Any, AwsError, MediaInsightsPipelineConfigurationNameString] =
      AwsError.unwrapOptionField(
        "mediaInsightsPipelineConfigurationName",
        mediaInsightsPipelineConfigurationName
      )
    def getMediaInsightsPipelineConfigurationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "mediaInsightsPipelineConfigurationArn",
        mediaInsightsPipelineConfigurationArn
      )
    def getResourceAccessRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceAccessRoleArn", resourceAccessRoleArn)
    def getRealTimeAlertConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "realTimeAlertConfiguration",
      realTimeAlertConfiguration
    )
    def getElements: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly
    ]] = AwsError.unwrapOptionField("elements", elements)
    def getMediaInsightsPipelineConfigurationId
        : ZIO[Any, AwsError, GuidString] = AwsError.unwrapOptionField(
      "mediaInsightsPipelineConfigurationId",
      mediaInsightsPipelineConfigurationId
    )
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration.ReadOnly {
    override val mediaInsightsPipelineConfigurationName
        : Optional[MediaInsightsPipelineConfigurationNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaInsightsPipelineConfigurationName())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .MediaInsightsPipelineConfigurationNameString(value)
        )
    override val mediaInsightsPipelineConfigurationArn: Optional[Arn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaInsightsPipelineConfigurationArn())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.Arn(value)
        )
    override val resourceAccessRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceAccessRoleArn())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
    override val realTimeAlertConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.realTimeAlertConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration
          .wrap(value)
      )
    override val elements: Optional[List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.elements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
            .wrap(item)
        }.toList
      )
    override val mediaInsightsPipelineConfigurationId: Optional[GuidString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaInsightsPipelineConfigurationId())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.GuidString(value)
        )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration
  ): zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration.ReadOnly =
    new Wrapper(impl)
}
