package zio.aws.chimesdkmediapipelines.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  Iso8601Timestamp,
  NonEmptyString,
  Arn,
  GuidString
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MediaInsightsPipeline(
    mediaPipelineId: Optional[GuidString] = Optional.Absent,
    mediaPipelineArn: Optional[Arn] = Optional.Absent,
    mediaInsightsPipelineConfigurationArn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus] =
      Optional.Absent,
    kinesisVideoStreamSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration
    ] = Optional.Absent,
    mediaInsightsRuntimeMetadata: Optional[Map[NonEmptyString, String]] =
      Optional.Absent,
    kinesisVideoStreamRecordingSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration
    ] = Optional.Absent,
    s3RecordingSinkRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipeline = {
    import MediaInsightsPipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipeline
      .builder()
      .optionallyWith(
        mediaPipelineId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.mediaPipelineId)
      .optionallyWith(
        mediaPipelineArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.mediaPipelineArn)
      .optionallyWith(
        mediaInsightsPipelineConfigurationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.mediaInsightsPipelineConfigurationArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        kinesisVideoStreamSourceRuntimeConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.kinesisVideoStreamSourceRuntimeConfiguration)
      .optionallyWith(
        mediaInsightsRuntimeMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(
                key
              ): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.mediaInsightsRuntimeMetadata)
      .optionallyWith(
        kinesisVideoStreamRecordingSourceRuntimeConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.kinesisVideoStreamRecordingSourceRuntimeConfiguration)
      .optionallyWith(
        s3RecordingSinkRuntimeConfiguration.map(value => value.buildAwsValue())
      )(_.s3RecordingSinkRuntimeConfiguration)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline
      .wrap(buildAwsValue())
}
object MediaInsightsPipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline =
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline(
        mediaPipelineId.map(value => value),
        mediaPipelineArn.map(value => value),
        mediaInsightsPipelineConfigurationArn.map(value => value),
        status.map(value => value),
        kinesisVideoStreamSourceRuntimeConfiguration.map(value =>
          value.asEditable
        ),
        mediaInsightsRuntimeMetadata.map(value => value),
        kinesisVideoStreamRecordingSourceRuntimeConfiguration.map(value =>
          value.asEditable
        ),
        s3RecordingSinkRuntimeConfiguration.map(value => value.asEditable),
        createdTimestamp.map(value => value)
      )
    def mediaPipelineId: Optional[GuidString]
    def mediaPipelineArn: Optional[Arn]
    def mediaInsightsPipelineConfigurationArn: Optional[Arn]
    def status
        : Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus]
    def kinesisVideoStreamSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.ReadOnly
    ]
    def mediaInsightsRuntimeMetadata: Optional[Map[NonEmptyString, String]]
    def kinesisVideoStreamRecordingSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.ReadOnly
    ]
    def s3RecordingSinkRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.ReadOnly
    ]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def getMediaPipelineId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("mediaPipelineId", mediaPipelineId)
    def getMediaPipelineArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("mediaPipelineArn", mediaPipelineArn)
    def getMediaInsightsPipelineConfigurationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "mediaInsightsPipelineConfigurationArn",
        mediaInsightsPipelineConfigurationArn
      )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getKinesisVideoStreamSourceRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisVideoStreamSourceRuntimeConfiguration",
      kinesisVideoStreamSourceRuntimeConfiguration
    )
    def getMediaInsightsRuntimeMetadata
        : ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField(
        "mediaInsightsRuntimeMetadata",
        mediaInsightsRuntimeMetadata
      )
    def getKinesisVideoStreamRecordingSourceRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisVideoStreamRecordingSourceRuntimeConfiguration",
      kinesisVideoStreamRecordingSourceRuntimeConfiguration
    )
    def getS3RecordingSinkRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3RecordingSinkRuntimeConfiguration",
      s3RecordingSinkRuntimeConfiguration
    )
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipeline
  ) extends zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline.ReadOnly {
    override val mediaPipelineId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaPipelineId())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.primitives.GuidString(value)
      )
    override val mediaPipelineArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaPipelineArn())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
    override val mediaInsightsPipelineConfigurationArn: Optional[Arn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaInsightsPipelineConfigurationArn())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.Arn(value)
        )
    override val status
        : Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.MediaPipelineStatus.wrap(value)
        )
    override val kinesisVideoStreamSourceRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisVideoStreamSourceRuntimeConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration
          .wrap(value)
      )
    override val mediaInsightsRuntimeMetadata
        : Optional[Map[NonEmptyString, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaInsightsRuntimeMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.chimesdkmediapipelines.model.primitives
              .NonEmptyString(key) -> (value: String)
          })
          .toMap
      )
    override val kinesisVideoStreamRecordingSourceRuntimeConfiguration
        : Optional[
          zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration.ReadOnly
        ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.kinesisVideoStreamRecordingSourceRuntimeConfiguration()
      )
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration
          .wrap(value)
      )
    override val s3RecordingSinkRuntimeConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3RecordingSinkRuntimeConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration
          .wrap(value)
      )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipeline
  ): zio.aws.chimesdkmediapipelines.model.MediaInsightsPipeline.ReadOnly =
    new Wrapper(impl)
}
