package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMediaInsightsPipelineConfigurationResponse(
    mediaInsightsPipelineConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse = {
    import CreateMediaInsightsPipelineConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse
      .builder()
      .optionallyWith(
        mediaInsightsPipelineConfiguration.map(value => value.buildAwsValue())
      )(_.mediaInsightsPipelineConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateMediaInsightsPipelineConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse =
      zio.aws.chimesdkmediapipelines.model
        .CreateMediaInsightsPipelineConfigurationResponse(
          mediaInsightsPipelineConfiguration.map(value => value.asEditable)
        )
    def mediaInsightsPipelineConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration.ReadOnly
    ]
    def getMediaInsightsPipelineConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mediaInsightsPipelineConfiguration",
      mediaInsightsPipelineConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse.ReadOnly {
    override val mediaInsightsPipelineConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaInsightsPipelineConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
