package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceARN: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ListTagsForResourceRequest =
      zio.aws.chimesdkmediapipelines.model
        .ListTagsForResourceRequest(resourceARN)
    def resourceARN: AmazonResourceName
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceRequest
  ) extends zio.aws.chimesdkmediapipelines.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.chimesdkmediapipelines.model.primitives
        .AmazonResourceName(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceRequest
  ): zio.aws.chimesdkmediapipelines.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
