package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{Keyword, RuleName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KeywordMatchConfiguration(
    ruleName: RuleName,
    keywords: Iterable[Keyword],
    negate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.KeywordMatchConfiguration = {
    import KeywordMatchConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KeywordMatchConfiguration
      .builder()
      .ruleName(RuleName.unwrap(ruleName): java.lang.String)
      .keywords(keywords.map { item =>
        Keyword.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(negate.map(value => value: java.lang.Boolean))(_.negate)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration
      .wrap(buildAwsValue())
}
object KeywordMatchConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KeywordMatchConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration =
      zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration(
        ruleName,
        keywords,
        negate.map(value => value)
      )
    def ruleName: RuleName
    def keywords: List[Keyword]
    def negate: Optional[Boolean]
    def getRuleName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(ruleName)
    def getKeywords: ZIO[Any, Nothing, List[Keyword]] = ZIO.succeed(keywords)
    def getNegate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("negate", negate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KeywordMatchConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration.ReadOnly {
    override val ruleName: RuleName =
      zio.aws.chimesdkmediapipelines.model.primitives.RuleName(impl.ruleName())
    override val keywords: List[Keyword] = impl
      .keywords()
      .asScala
      .map { item =>
        zio.aws.chimesdkmediapipelines.model.primitives.Keyword(item)
      }
      .toList
    override val negate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.negate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KeywordMatchConfiguration
  ): zio.aws.chimesdkmediapipelines.model.KeywordMatchConfiguration.ReadOnly =
    new Wrapper(impl)
}
