package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait ArtifactsConcatenationState {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState
}
object ArtifactsConcatenationState {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState
  ): zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationState =
    value match {
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState.ENABLED =>
        val r = Enabled
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState.DISABLED =>
        val r = Disabled
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationState {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationState {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState.ENABLED
  }
  case object Disabled
      extends zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationState {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationState.DISABLED
  }
}
