package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait AudioChannelsOption {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption
}
object AudioChannelsOption {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption
  ): zio.aws.chimesdkmediapipelines.model.AudioChannelsOption = value match {
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption.STEREO =>
      val r = Stereo
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption.MONO =>
      val r = Mono
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.AudioChannelsOption {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption.UNKNOWN_TO_SDK_VERSION
  }
  case object Stereo
      extends zio.aws.chimesdkmediapipelines.model.AudioChannelsOption {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption.STEREO
  }
  case object Mono
      extends zio.aws.chimesdkmediapipelines.model.AudioChannelsOption {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioChannelsOption.MONO
  }
}
