package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3RecordingSinkConfiguration(
    destination: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration = {
    import S3RecordingSinkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
      .builder()
      .optionallyWith(
        destination.map(value => Arn.unwrap(value): java.lang.String)
      )(_.destination)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
      .wrap(buildAwsValue())
}
object S3RecordingSinkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .S3RecordingSinkConfiguration(destination.map(value => value))
    def destination: Optional[Arn]
    def getDestination: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration.ReadOnly {
    override val destination: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.chimesdkmediapipelines.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
  ): zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration.ReadOnly =
    new Wrapper(impl)
}
