package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MediaInsightsPipelineConfigurationElement(
    `type`: zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElementType,
    amazonTranscribeCallAnalyticsProcessorConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration
    ] = Optional.Absent,
    amazonTranscribeProcessorConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration
    ] = Optional.Absent,
    kinesisDataStreamSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration
    ] = Optional.Absent,
    s3RecordingSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
    ] = Optional.Absent,
    voiceAnalyticsProcessorConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration
    ] = Optional.Absent,
    lambdaFunctionSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration
    ] = Optional.Absent,
    sqsQueueSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration
    ] = Optional.Absent,
    snsTopicSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement = {
    import MediaInsightsPipelineConfigurationElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        amazonTranscribeCallAnalyticsProcessorConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.amazonTranscribeCallAnalyticsProcessorConfiguration)
      .optionallyWith(
        amazonTranscribeProcessorConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.amazonTranscribeProcessorConfiguration)
      .optionallyWith(
        kinesisDataStreamSinkConfiguration.map(value => value.buildAwsValue())
      )(_.kinesisDataStreamSinkConfiguration)
      .optionallyWith(
        s3RecordingSinkConfiguration.map(value => value.buildAwsValue())
      )(_.s3RecordingSinkConfiguration)
      .optionallyWith(
        voiceAnalyticsProcessorConfiguration.map(value => value.buildAwsValue())
      )(_.voiceAnalyticsProcessorConfiguration)
      .optionallyWith(
        lambdaFunctionSinkConfiguration.map(value => value.buildAwsValue())
      )(_.lambdaFunctionSinkConfiguration)
      .optionallyWith(
        sqsQueueSinkConfiguration.map(value => value.buildAwsValue())
      )(_.sqsQueueSinkConfiguration)
      .optionallyWith(
        snsTopicSinkConfiguration.map(value => value.buildAwsValue())
      )(_.snsTopicSinkConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
      .wrap(buildAwsValue())
}
object MediaInsightsPipelineConfigurationElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement =
      zio.aws.chimesdkmediapipelines.model
        .MediaInsightsPipelineConfigurationElement(
          `type`,
          amazonTranscribeCallAnalyticsProcessorConfiguration.map(value =>
            value.asEditable
          ),
          amazonTranscribeProcessorConfiguration.map(value => value.asEditable),
          kinesisDataStreamSinkConfiguration.map(value => value.asEditable),
          s3RecordingSinkConfiguration.map(value => value.asEditable),
          voiceAnalyticsProcessorConfiguration.map(value => value.asEditable),
          lambdaFunctionSinkConfiguration.map(value => value.asEditable),
          sqsQueueSinkConfiguration.map(value => value.asEditable),
          snsTopicSinkConfiguration.map(value => value.asEditable)
        )
    def `type`: zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElementType
    def amazonTranscribeCallAnalyticsProcessorConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration.ReadOnly
    ]
    def amazonTranscribeProcessorConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration.ReadOnly
    ]
    def kinesisDataStreamSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration.ReadOnly
    ]
    def s3RecordingSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration.ReadOnly
    ]
    def voiceAnalyticsProcessorConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration.ReadOnly
    ]
    def lambdaFunctionSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration.ReadOnly
    ]
    def sqsQueueSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration.ReadOnly
    ]
    def snsTopicSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration.ReadOnly
    ]
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElementType
    ] = ZIO.succeed(`type`)
    def getAmazonTranscribeCallAnalyticsProcessorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amazonTranscribeCallAnalyticsProcessorConfiguration",
      amazonTranscribeCallAnalyticsProcessorConfiguration
    )
    def getAmazonTranscribeProcessorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amazonTranscribeProcessorConfiguration",
      amazonTranscribeProcessorConfiguration
    )
    def getKinesisDataStreamSinkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisDataStreamSinkConfiguration",
      kinesisDataStreamSinkConfiguration
    )
    def getS3RecordingSinkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3RecordingSinkConfiguration",
      s3RecordingSinkConfiguration
    )
    def getVoiceAnalyticsProcessorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "voiceAnalyticsProcessorConfiguration",
      voiceAnalyticsProcessorConfiguration
    )
    def getLambdaFunctionSinkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionSinkConfiguration",
      lambdaFunctionSinkConfiguration
    )
    def getSqsQueueSinkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sqsQueueSinkConfiguration",
      sqsQueueSinkConfiguration
    )
    def getSnsTopicSinkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "snsTopicSinkConfiguration",
      snsTopicSinkConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
  ) extends zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly {
    override val `type`
        : zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElementType =
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElementType
        .wrap(impl.`type`())
    override val amazonTranscribeCallAnalyticsProcessorConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.amazonTranscribeCallAnalyticsProcessorConfiguration()
      )
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.AmazonTranscribeCallAnalyticsProcessorConfiguration
          .wrap(value)
      )
    override val amazonTranscribeProcessorConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonTranscribeProcessorConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.AmazonTranscribeProcessorConfiguration
          .wrap(value)
      )
    override val kinesisDataStreamSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisDataStreamSinkConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.KinesisDataStreamSinkConfiguration
          .wrap(value)
      )
    override val s3RecordingSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3RecordingSinkConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.S3RecordingSinkConfiguration
          .wrap(value)
      )
    override val voiceAnalyticsProcessorConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceAnalyticsProcessorConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.VoiceAnalyticsProcessorConfiguration
          .wrap(value)
      )
    override val lambdaFunctionSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionSinkConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.LambdaFunctionSinkConfiguration
          .wrap(value)
      )
    override val sqsQueueSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sqsQueueSinkConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.SqsQueueSinkConfiguration
          .wrap(value)
      )
    override val snsTopicSinkConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicSinkConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.SnsTopicSinkConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
  ): zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly =
    new Wrapper(impl)
}
