package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  Arn,
  GuidString,
  MediaInsightsPipelineConfigurationNameString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MediaInsightsPipelineConfigurationSummary(
    mediaInsightsPipelineConfigurationName: Optional[
      MediaInsightsPipelineConfigurationNameString
    ] = Optional.Absent,
    mediaInsightsPipelineConfigurationId: Optional[GuidString] =
      Optional.Absent,
    mediaInsightsPipelineConfigurationArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary = {
    import MediaInsightsPipelineConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary
      .builder()
      .optionallyWith(
        mediaInsightsPipelineConfigurationName.map(value =>
          MediaInsightsPipelineConfigurationNameString.unwrap(
            value
          ): java.lang.String
        )
      )(_.mediaInsightsPipelineConfigurationName)
      .optionallyWith(
        mediaInsightsPipelineConfigurationId.map(value =>
          GuidString.unwrap(value): java.lang.String
        )
      )(_.mediaInsightsPipelineConfigurationId)
      .optionallyWith(
        mediaInsightsPipelineConfigurationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.mediaInsightsPipelineConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary
      .wrap(buildAwsValue())
}
object MediaInsightsPipelineConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary =
      zio.aws.chimesdkmediapipelines.model
        .MediaInsightsPipelineConfigurationSummary(
          mediaInsightsPipelineConfigurationName.map(value => value),
          mediaInsightsPipelineConfigurationId.map(value => value),
          mediaInsightsPipelineConfigurationArn.map(value => value)
        )
    def mediaInsightsPipelineConfigurationName
        : Optional[MediaInsightsPipelineConfigurationNameString]
    def mediaInsightsPipelineConfigurationId: Optional[GuidString]
    def mediaInsightsPipelineConfigurationArn: Optional[Arn]
    def getMediaInsightsPipelineConfigurationName
        : ZIO[Any, AwsError, MediaInsightsPipelineConfigurationNameString] =
      AwsError.unwrapOptionField(
        "mediaInsightsPipelineConfigurationName",
        mediaInsightsPipelineConfigurationName
      )
    def getMediaInsightsPipelineConfigurationId
        : ZIO[Any, AwsError, GuidString] = AwsError.unwrapOptionField(
      "mediaInsightsPipelineConfigurationId",
      mediaInsightsPipelineConfigurationId
    )
    def getMediaInsightsPipelineConfigurationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "mediaInsightsPipelineConfigurationArn",
        mediaInsightsPipelineConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary
  ) extends zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.ReadOnly {
    override val mediaInsightsPipelineConfigurationName
        : Optional[MediaInsightsPipelineConfigurationNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaInsightsPipelineConfigurationName())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .MediaInsightsPipelineConfigurationNameString(value)
        )
    override val mediaInsightsPipelineConfigurationId: Optional[GuidString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaInsightsPipelineConfigurationId())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.GuidString(value)
        )
    override val mediaInsightsPipelineConfigurationArn: Optional[Arn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaInsightsPipelineConfigurationArn())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.Arn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary
  ): zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationSummary.ReadOnly =
    new Wrapper(impl)
}
