package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.GuidString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMediaCapturePipelineRequest(mediaPipelineId: GuidString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest = {
    import GetMediaCapturePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest
      .builder()
      .mediaPipelineId(GuidString.unwrap(mediaPipelineId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest
      .wrap(buildAwsValue())
}
object GetMediaCapturePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest =
      zio.aws.chimesdkmediapipelines.model
        .GetMediaCapturePipelineRequest(mediaPipelineId)
    def mediaPipelineId: GuidString
    def getMediaPipelineId: ZIO[Any, Nothing, GuidString] =
      ZIO.succeed(mediaPipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest
  ) extends zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest.ReadOnly {
    override val mediaPipelineId: GuidString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .GuidString(impl.mediaPipelineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest
  ): zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
