package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MediaCapturePipelineSourceConfiguration(
    mediaPipelineArn: Arn,
    chimeSdkMeetingConfiguration: zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConcatenationConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration = {
    import MediaCapturePipelineSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration
      .builder()
      .mediaPipelineArn(Arn.unwrap(mediaPipelineArn): java.lang.String)
      .chimeSdkMeetingConfiguration(
        chimeSdkMeetingConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration
      .wrap(buildAwsValue())
}
object MediaCapturePipelineSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .MediaCapturePipelineSourceConfiguration(
          mediaPipelineArn,
          chimeSdkMeetingConfiguration.asEditable
        )
    def mediaPipelineArn: Arn
    def chimeSdkMeetingConfiguration
        : zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConcatenationConfiguration.ReadOnly
    def getMediaPipelineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(mediaPipelineArn)
    def getChimeSdkMeetingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConcatenationConfiguration.ReadOnly
    ] = ZIO.succeed(chimeSdkMeetingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration.ReadOnly {
    override val mediaPipelineArn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives
        .Arn(impl.mediaPipelineArn())
    override val chimeSdkMeetingConfiguration
        : zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConcatenationConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.ChimeSdkMeetingConcatenationConfiguration
        .wrap(impl.chimeSdkMeetingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration
  ): zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSourceConfiguration.ReadOnly =
    new Wrapper(impl)
}
