package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMediaCapturePipelineResponse(
    mediaCapturePipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse = {
    import GetMediaCapturePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse
      .builder()
      .optionallyWith(mediaCapturePipeline.map(value => value.buildAwsValue()))(
        _.mediaCapturePipeline
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse
      .wrap(buildAwsValue())
}
object GetMediaCapturePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse =
      zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse(
        mediaCapturePipeline.map(value => value.asEditable)
      )
    def mediaCapturePipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.ReadOnly
    ]
    def getMediaCapturePipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.ReadOnly
    ] = AwsError.unwrapOptionField("mediaCapturePipeline", mediaCapturePipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse
  ) extends zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly {
    override val mediaCapturePipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaCapturePipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse
  ): zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly =
    new Wrapper(impl)
}
