package zio.aws.chimesdkmediapipelines
import zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.chimesdkmediapipelines.{
  ChimeSdkMediaPipelinesAsyncClientBuilder,
  ChimeSdkMediaPipelinesAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.chimesdkmediapipelines.model.{
  GetMediaPipelineRequest,
  ListMediaPipelinesRequest,
  GetMediaCapturePipelineRequest,
  ListMediaCapturePipelinesRequest,
  ListTagsForResourceRequest,
  CreateMediaLiveConnectorPipelineRequest,
  DeleteMediaCapturePipelineRequest,
  CreateMediaCapturePipelineRequest,
  UntagResourceRequest,
  DeleteMediaPipelineRequest,
  CreateMediaConcatenationPipelineRequest,
  TagResourceRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.chimesdkmediapipelines.model.{
  DeleteMediaPipelineResponse,
  MediaCapturePipelineSummary,
  CreateMediaConcatenationPipelineResponse,
  CreateMediaCapturePipelineResponse,
  GetMediaPipelineResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteMediaCapturePipelineResponse,
  MediaPipelineSummary,
  GetMediaCapturePipelineResponse,
  ListMediaCapturePipelinesResponse,
  TagResourceResponse,
  ListMediaPipelinesResponse,
  CreateMediaLiveConnectorPipelineResponse
}
import scala.jdk.CollectionConverters.*
trait ChimeSdkMediaPipelines extends AspectSupport[ChimeSdkMediaPipelines] {
  val api: ChimeSdkMediaPipelinesAsyncClient
  def deleteMediaPipeline(
      request: DeleteMediaPipelineRequest
  ): IO[AwsError, Unit]
  def getMediaCapturePipeline(request: GetMediaCapturePipelineRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
  ]
  def getMediaPipeline(request: GetMediaPipelineRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly
  ]
  def listMediaPipelines(request: ListMediaPipelinesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly
  ]
  def listMediaPipelinesPaginated(
      request: ListMediaPipelinesRequest
  ): IO[AwsError, ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
  ]
  def createMediaConcatenationPipeline(
      request: CreateMediaConcatenationPipelineRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly
  ]
  def createMediaLiveConnectorPipeline(
      request: CreateMediaLiveConnectorPipelineRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly
  ]
  def createMediaCapturePipeline(
      request: CreateMediaCapturePipelineRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
  ]
  def deleteMediaCapturePipeline(
      request: DeleteMediaCapturePipelineRequest
  ): IO[AwsError, Unit]
  def listMediaCapturePipelines(
      request: ListMediaCapturePipelinesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
  ]
  def listMediaCapturePipelinesPaginated(
      request: ListMediaCapturePipelinesRequest
  ): IO[
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly
  ]
}
object ChimeSdkMediaPipelines {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkMediaPipelines] =
    customized(identity)
  def customized(
      customization: ChimeSdkMediaPipelinesAsyncClientBuilder => ChimeSdkMediaPipelinesAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ChimeSdkMediaPipelines] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ChimeSdkMediaPipelinesAsyncClientBuilder => ChimeSdkMediaPipelinesAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ChimeSdkMediaPipelines] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = ChimeSdkMediaPipelinesAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        ChimeSdkMediaPipelinesAsyncClient,
        ChimeSdkMediaPipelinesAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        ChimeSdkMediaPipelinesAsyncClient,
        ChimeSdkMediaPipelinesAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new ChimeSdkMediaPipelinesImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class ChimeSdkMediaPipelinesImpl[R](
      override val api: ChimeSdkMediaPipelinesAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ChimeSdkMediaPipelines
      with AwsServiceBase[R] {
    override val serviceName: String = "ChimeSdkMediaPipelines"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ChimeSdkMediaPipelinesImpl[R1] =
      new ChimeSdkMediaPipelinesImpl(api, newAspect, r)
    def deleteMediaPipeline(
        request: DeleteMediaPipelineRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest,
      DeleteMediaPipelineResponse
    ]("deleteMediaPipeline", api.deleteMediaPipeline)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getMediaCapturePipeline(request: GetMediaCapturePipelineRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest,
      GetMediaCapturePipelineResponse
    ]("getMediaCapturePipeline", api.getMediaCapturePipeline)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.wrap
    ).provideEnvironment(r)
    def getMediaPipeline(request: GetMediaPipelineRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineRequest,
      GetMediaPipelineResponse
    ]("getMediaPipeline", api.getMediaPipeline)(request.buildAwsValue())
      .map(zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.wrap)
      .provideEnvironment(r)
    def listMediaPipelines(request: ListMediaPipelinesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest,
      ListMediaPipelinesResponse,
      MediaPipelineSummary
    ](
      "listMediaPipelines",
      api.listMediaPipelines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.mediaPipelines().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listMediaPipelinesPaginated(
        request: ListMediaPipelinesRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest,
      ListMediaPipelinesResponse
    ]("listMediaPipelines", api.listMediaPipelines)(request.buildAwsValue())
      .map(zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.wrap
      )
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.chimesdkmediapipelines.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def createMediaConcatenationPipeline(
        request: CreateMediaConcatenationPipelineRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineRequest,
      CreateMediaConcatenationPipelineResponse
    ]("createMediaConcatenationPipeline", api.createMediaConcatenationPipeline)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.wrap
    ).provideEnvironment(r)
    def createMediaLiveConnectorPipeline(
        request: CreateMediaLiveConnectorPipelineRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineRequest,
      CreateMediaLiveConnectorPipelineResponse
    ]("createMediaLiveConnectorPipeline", api.createMediaLiveConnectorPipeline)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.wrap
    ).provideEnvironment(r)
    def createMediaCapturePipeline(
        request: CreateMediaCapturePipelineRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest,
      CreateMediaCapturePipelineResponse
    ]("createMediaCapturePipeline", api.createMediaCapturePipeline)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.wrap
    ).provideEnvironment(r)
    def deleteMediaCapturePipeline(
        request: DeleteMediaCapturePipelineRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest,
      DeleteMediaCapturePipelineResponse
    ]("deleteMediaCapturePipeline", api.deleteMediaCapturePipeline)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listMediaCapturePipelines(
        request: ListMediaCapturePipelinesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest,
      ListMediaCapturePipelinesResponse,
      MediaCapturePipelineSummary
    ](
      "listMediaCapturePipelines",
      api.listMediaCapturePipelines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.mediaCapturePipelines().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listMediaCapturePipelinesPaginated(
        request: ListMediaCapturePipelinesRequest
    ): IO[
      AwsError,
      zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest,
      ListMediaCapturePipelinesResponse
    ]("listMediaCapturePipelines", api.listMediaCapturePipelines)(
      request.buildAwsValue()
    ).map(
      zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.wrap
    ).provideEnvironment(r)
  }
  def deleteMediaPipeline(request: DeleteMediaPipelineRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteMediaPipeline(request))
  def getMediaCapturePipeline(request: GetMediaCapturePipelineRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMediaCapturePipeline(request))
  def getMediaPipeline(request: GetMediaPipelineRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMediaPipeline(request))
  def listMediaPipelines(request: ListMediaPipelinesRequest): ZStream[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMediaPipelines(request))
  def listMediaPipelinesPaginated(request: ListMediaPipelinesRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.listMediaPipelinesPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createMediaConcatenationPipeline(
      request: CreateMediaConcatenationPipelineRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMediaConcatenationPipeline(request))
  def createMediaLiveConnectorPipeline(
      request: CreateMediaLiveConnectorPipelineRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMediaLiveConnectorPipeline(request))
  def createMediaCapturePipeline(
      request: CreateMediaCapturePipelineRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMediaCapturePipeline(request))
  def deleteMediaCapturePipeline(
      request: DeleteMediaCapturePipelineRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteMediaCapturePipeline(request))
  def listMediaCapturePipelines(
      request: ListMediaCapturePipelinesRequest
  ): ZStream[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMediaCapturePipelines(request))
  def listMediaCapturePipelinesPaginated(
      request: ListMediaCapturePipelinesRequest
  ): ZIO[
    zio.aws.chimesdkmediapipelines.ChimeSdkMediaPipelines,
    AwsError,
    zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMediaCapturePipelinesPaginated(request))
}
