package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMediaLiveConnectorPipelineResponse(
    mediaLiveConnectorPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse = {
    import CreateMediaLiveConnectorPipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse
      .builder()
      .optionallyWith(
        mediaLiveConnectorPipeline.map(value => value.buildAwsValue())
      )(_.mediaLiveConnectorPipeline)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse
      .wrap(buildAwsValue())
}
object CreateMediaLiveConnectorPipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse =
      zio.aws.chimesdkmediapipelines.model
        .CreateMediaLiveConnectorPipelineResponse(
          mediaLiveConnectorPipeline.map(value => value.asEditable)
        )
    def mediaLiveConnectorPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline.ReadOnly
    ]
    def getMediaLiveConnectorPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mediaLiveConnectorPipeline",
      mediaLiveConnectorPipeline
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly {
    override val mediaLiveConnectorPipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaLiveConnectorPipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaLiveConnectorPipeline
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly =
    new Wrapper(impl)
}
