package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ArtifactsConcatenationConfiguration(
    audio: zio.aws.chimesdkmediapipelines.model.AudioConcatenationConfiguration,
    video: zio.aws.chimesdkmediapipelines.model.VideoConcatenationConfiguration,
    content: zio.aws.chimesdkmediapipelines.model.ContentConcatenationConfiguration,
    dataChannel: zio.aws.chimesdkmediapipelines.model.DataChannelConcatenationConfiguration,
    transcriptionMessages: zio.aws.chimesdkmediapipelines.model.TranscriptionMessagesConcatenationConfiguration,
    meetingEvents: zio.aws.chimesdkmediapipelines.model.MeetingEventsConcatenationConfiguration,
    compositedVideo: zio.aws.chimesdkmediapipelines.model.CompositedVideoConcatenationConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration = {
    import ArtifactsConcatenationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration
      .builder()
      .audio(audio.buildAwsValue())
      .video(video.buildAwsValue())
      .content(content.buildAwsValue())
      .dataChannel(dataChannel.buildAwsValue())
      .transcriptionMessages(transcriptionMessages.buildAwsValue())
      .meetingEvents(meetingEvents.buildAwsValue())
      .compositedVideo(compositedVideo.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration
      .wrap(buildAwsValue())
}
object ArtifactsConcatenationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration =
      zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration(
        audio.asEditable,
        video.asEditable,
        content.asEditable,
        dataChannel.asEditable,
        transcriptionMessages.asEditable,
        meetingEvents.asEditable,
        compositedVideo.asEditable
      )
    def audio
        : zio.aws.chimesdkmediapipelines.model.AudioConcatenationConfiguration.ReadOnly
    def video
        : zio.aws.chimesdkmediapipelines.model.VideoConcatenationConfiguration.ReadOnly
    def content
        : zio.aws.chimesdkmediapipelines.model.ContentConcatenationConfiguration.ReadOnly
    def dataChannel
        : zio.aws.chimesdkmediapipelines.model.DataChannelConcatenationConfiguration.ReadOnly
    def transcriptionMessages
        : zio.aws.chimesdkmediapipelines.model.TranscriptionMessagesConcatenationConfiguration.ReadOnly
    def meetingEvents
        : zio.aws.chimesdkmediapipelines.model.MeetingEventsConcatenationConfiguration.ReadOnly
    def compositedVideo
        : zio.aws.chimesdkmediapipelines.model.CompositedVideoConcatenationConfiguration.ReadOnly
    def getAudio: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.AudioConcatenationConfiguration.ReadOnly
    ] = ZIO.succeed(audio)
    def getVideo: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.VideoConcatenationConfiguration.ReadOnly
    ] = ZIO.succeed(video)
    def getContent: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.ContentConcatenationConfiguration.ReadOnly
    ] = ZIO.succeed(content)
    def getDataChannel: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.DataChannelConcatenationConfiguration.ReadOnly
    ] = ZIO.succeed(dataChannel)
    def getTranscriptionMessages: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.TranscriptionMessagesConcatenationConfiguration.ReadOnly
    ] = ZIO.succeed(transcriptionMessages)
    def getMeetingEvents: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.MeetingEventsConcatenationConfiguration.ReadOnly
    ] = ZIO.succeed(meetingEvents)
    def getCompositedVideo: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.CompositedVideoConcatenationConfiguration.ReadOnly
    ] = ZIO.succeed(compositedVideo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration.ReadOnly {
    override val audio
        : zio.aws.chimesdkmediapipelines.model.AudioConcatenationConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.AudioConcatenationConfiguration
        .wrap(impl.audio())
    override val video
        : zio.aws.chimesdkmediapipelines.model.VideoConcatenationConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.VideoConcatenationConfiguration
        .wrap(impl.video())
    override val content
        : zio.aws.chimesdkmediapipelines.model.ContentConcatenationConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.ContentConcatenationConfiguration
        .wrap(impl.content())
    override val dataChannel
        : zio.aws.chimesdkmediapipelines.model.DataChannelConcatenationConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.DataChannelConcatenationConfiguration
        .wrap(impl.dataChannel())
    override val transcriptionMessages
        : zio.aws.chimesdkmediapipelines.model.TranscriptionMessagesConcatenationConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.TranscriptionMessagesConcatenationConfiguration
        .wrap(impl.transcriptionMessages())
    override val meetingEvents
        : zio.aws.chimesdkmediapipelines.model.MeetingEventsConcatenationConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.MeetingEventsConcatenationConfiguration
        .wrap(impl.meetingEvents())
    override val compositedVideo
        : zio.aws.chimesdkmediapipelines.model.CompositedVideoConcatenationConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.CompositedVideoConcatenationConfiguration
        .wrap(impl.compositedVideo())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration
  ): zio.aws.chimesdkmediapipelines.model.ArtifactsConcatenationConfiguration.ReadOnly =
    new Wrapper(impl)
}
