package zio.aws.chimesdkmediapipelines.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.ResultMax
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMediaPipelinesRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest = {
    import ListMediaPipelinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesRequest
      .wrap(buildAwsValue())
}
object ListMediaPipelinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesRequest =
      zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[ResultMax]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest
  ) extends zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.primitives.ResultMax(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest
  ): zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesRequest.ReadOnly =
    new Wrapper(impl)
}
