package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceConfiguration(
    selectedVideoStreams: Optional[
      zio.aws.chimesdkmediapipelines.model.SelectedVideoStreams
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.SourceConfiguration = {
    import SourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SourceConfiguration
      .builder()
      .optionallyWith(selectedVideoStreams.map(value => value.buildAwsValue()))(
        _.selectedVideoStreams
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.SourceConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.SourceConfiguration
      .wrap(buildAwsValue())
}
object SourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.SourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.SourceConfiguration =
      zio.aws.chimesdkmediapipelines.model.SourceConfiguration(
        selectedVideoStreams.map(value => value.asEditable)
      )
    def selectedVideoStreams: Optional[
      zio.aws.chimesdkmediapipelines.model.SelectedVideoStreams.ReadOnly
    ]
    def getSelectedVideoStreams: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.SelectedVideoStreams.ReadOnly
    ] = AwsError.unwrapOptionField("selectedVideoStreams", selectedVideoStreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SourceConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.SourceConfiguration.ReadOnly {
    override val selectedVideoStreams: Optional[
      zio.aws.chimesdkmediapipelines.model.SelectedVideoStreams.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.selectedVideoStreams())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.SelectedVideoStreams.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.SourceConfiguration
  ): zio.aws.chimesdkmediapipelines.model.SourceConfiguration.ReadOnly =
    new Wrapper(impl)
}
