package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{
  AmazonResourceName,
  GuidString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MediaPipelineSummary(
    mediaPipelineId: Optional[GuidString] = Optional.Absent,
    mediaPipelineArn: Optional[AmazonResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSummary = {
    import MediaPipelineSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSummary
      .builder()
      .optionallyWith(
        mediaPipelineId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.mediaPipelineId)
      .optionallyWith(
        mediaPipelineArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.mediaPipelineArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary
      .wrap(buildAwsValue())
}
object MediaPipelineSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary =
      zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary(
        mediaPipelineId.map(value => value),
        mediaPipelineArn.map(value => value)
      )
    def mediaPipelineId: Optional[GuidString]
    def mediaPipelineArn: Optional[AmazonResourceName]
    def getMediaPipelineId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("mediaPipelineId", mediaPipelineId)
    def getMediaPipelineArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("mediaPipelineArn", mediaPipelineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSummary
  ) extends zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly {
    override val mediaPipelineId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaPipelineId())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.primitives.GuidString(value)
      )
    override val mediaPipelineArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mediaPipelineArn())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .AmazonResourceName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineSummary
  ): zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly =
    new Wrapper(impl)
}
