package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters.*
sealed trait AudioMuxType {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType
}
object AudioMuxType {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType
  ): zio.aws.chimesdkmediapipelines.model.AudioMuxType = value match {
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType.AUDIO_ONLY =>
      val r = AudioOnly
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType.AUDIO_WITH_ACTIVE_SPEAKER_VIDEO =>
      val r = AudioWithActiveSpeakerVideo
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType.AUDIO_WITH_COMPOSITED_VIDEO =>
      val r = AudioWithCompositedVideo
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.AudioMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType.UNKNOWN_TO_SDK_VERSION
  }
  case object AudioOnly
      extends zio.aws.chimesdkmediapipelines.model.AudioMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType.AUDIO_ONLY
  }
  case object AudioWithActiveSpeakerVideo
      extends zio.aws.chimesdkmediapipelines.model.AudioMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType.AUDIO_WITH_ACTIVE_SPEAKER_VIDEO
  }
  case object AudioWithCompositedVideo
      extends zio.aws.chimesdkmediapipelines.model.AudioMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.AudioMuxType.AUDIO_WITH_COMPOSITED_VIDEO
  }
}
