package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMediaCapturePipelineResponse(
    mediaCapturePipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse = {
    import CreateMediaCapturePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse
      .builder()
      .optionallyWith(mediaCapturePipeline.map(value => value.buildAwsValue()))(
        _.mediaCapturePipeline
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse
      .wrap(buildAwsValue())
}
object CreateMediaCapturePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse =
      zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse(
        mediaCapturePipeline.map(value => value.asEditable)
      )
    def mediaCapturePipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.ReadOnly
    ]
    def getMediaCapturePipeline: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.ReadOnly
    ] = AwsError.unwrapOptionField("mediaCapturePipeline", mediaCapturePipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse
  ) extends zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly {
    override val mediaCapturePipeline: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaCapturePipeline())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaCapturePipeline.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse
  ): zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly =
    new Wrapper(impl)
}
