package zio.aws.chimesdkmediapipelines
import zio.aws.chimesdkmediapipelines.model.ListMediaPipelinesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.chimesdkmediapipelines.model.{
  GetMediaPipelineRequest,
  ListMediaPipelinesRequest,
  GetMediaCapturePipelineRequest,
  ListMediaCapturePipelinesRequest,
  ListTagsForResourceRequest,
  CreateMediaLiveConnectorPipelineRequest,
  DeleteMediaCapturePipelineRequest,
  CreateMediaCapturePipelineRequest,
  UntagResourceRequest,
  DeleteMediaPipelineRequest,
  CreateMediaConcatenationPipelineRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object ChimeSdkMediaPipelinesMock extends Mock[ChimeSdkMediaPipelines] {
  object DeleteMediaPipeline
      extends Effect[DeleteMediaPipelineRequest, AwsError, Unit]
  object GetMediaCapturePipeline
      extends Effect[
        GetMediaCapturePipelineRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
      ]
  object GetMediaPipeline
      extends Effect[
        GetMediaPipelineRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly
      ]
  object ListMediaPipelines
      extends Stream[
        ListMediaPipelinesRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly
      ]
  object ListMediaPipelinesPaginated
      extends Effect[ListMediaPipelinesRequest, AwsError, ReadOnly]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
      ]
  object CreateMediaConcatenationPipeline
      extends Effect[
        CreateMediaConcatenationPipelineRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly
      ]
  object CreateMediaLiveConnectorPipeline
      extends Effect[
        CreateMediaLiveConnectorPipelineRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly
      ]
  object CreateMediaCapturePipeline
      extends Effect[
        CreateMediaCapturePipelineRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
      ]
  object DeleteMediaCapturePipeline
      extends Effect[DeleteMediaCapturePipelineRequest, AwsError, Unit]
  object ListMediaCapturePipelines
      extends Stream[
        ListMediaCapturePipelinesRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
      ]
  object ListMediaCapturePipelinesPaginated
      extends Effect[
        ListMediaCapturePipelinesRequest,
        AwsError,
        zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ChimeSdkMediaPipelines] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ChimeSdkMediaPipelines] { rts =>
        zio.ZIO.succeed {
          new ChimeSdkMediaPipelines {
            val api: ChimeSdkMediaPipelinesAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ChimeSdkMediaPipelines = this
            def deleteMediaPipeline(
                request: DeleteMediaPipelineRequest
            ): IO[AwsError, Unit] = proxy(DeleteMediaPipeline, request)
            def getMediaCapturePipeline(
                request: GetMediaCapturePipelineRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse.ReadOnly
            ] = proxy(GetMediaCapturePipeline, request)
            def getMediaPipeline(request: GetMediaPipelineRequest): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.GetMediaPipelineResponse.ReadOnly
            ] = proxy(GetMediaPipeline, request)
            def listMediaPipelines(request: ListMediaPipelinesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmediapipelines.model.MediaPipelineSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMediaPipelines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMediaPipelinesPaginated(
                request: ListMediaPipelinesRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListMediaPipelinesPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createMediaConcatenationPipeline(
                request: CreateMediaConcatenationPipelineRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse.ReadOnly
            ] = proxy(CreateMediaConcatenationPipeline, request)
            def createMediaLiveConnectorPipeline(
                request: CreateMediaLiveConnectorPipelineRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse.ReadOnly
            ] = proxy(CreateMediaLiveConnectorPipeline, request)
            def createMediaCapturePipeline(
                request: CreateMediaCapturePipelineRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse.ReadOnly
            ] = proxy(CreateMediaCapturePipeline, request)
            def deleteMediaCapturePipeline(
                request: DeleteMediaCapturePipelineRequest
            ): IO[AwsError, Unit] = proxy(DeleteMediaCapturePipeline, request)
            def listMediaCapturePipelines(
                request: ListMediaCapturePipelinesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmediapipelines.model.MediaCapturePipelineSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMediaCapturePipelines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMediaCapturePipelinesPaginated(
                request: ListMediaCapturePipelinesRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse.ReadOnly
            ] = proxy(ListMediaCapturePipelinesPaginated, request)
          }
        }
      }
    }
  }
}
