package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ArtifactsConfiguration(
    audio: zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration,
    video: zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration,
    content: zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConfiguration = {
    import ArtifactsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConfiguration
      .builder()
      .audio(audio.buildAwsValue())
      .video(video.buildAwsValue())
      .content(content.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration
      .wrap(buildAwsValue())
}
object ArtifactsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration =
      zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration(
        audio.asEditable,
        video.asEditable,
        content.asEditable
      )
    def audio: zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration.ReadOnly
    def video: zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration.ReadOnly
    def content
        : zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration.ReadOnly
    def getAudio: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration.ReadOnly
    ] = ZIO.succeed(audio)
    def getVideo: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration.ReadOnly
    ] = ZIO.succeed(video)
    def getContent: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration.ReadOnly
    ] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration.ReadOnly {
    override val audio
        : zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.AudioArtifactsConfiguration
        .wrap(impl.audio())
    override val video
        : zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.VideoArtifactsConfiguration
        .wrap(impl.video())
    override val content
        : zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration.ReadOnly =
      zio.aws.chimesdkmediapipelines.model.ContentArtifactsConfiguration
        .wrap(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.ArtifactsConfiguration
  ): zio.aws.chimesdkmediapipelines.model.ArtifactsConfiguration.ReadOnly =
    new Wrapper(impl)
}
