package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VoiceEnhancementSinkConfiguration(
    disabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration = {
    import VoiceEnhancementSinkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration
      .builder()
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration
      .wrap(buildAwsValue())
}
object VoiceEnhancementSinkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .VoiceEnhancementSinkConfiguration(disabled.map(value => value))
    def disabled: Optional[Boolean]
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration.ReadOnly {
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration
  ): zio.aws.chimesdkmediapipelines.model.VoiceEnhancementSinkConfiguration.ReadOnly =
    new Wrapper(impl)
}
