package zio.aws.chimesdkmediapipelines.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  FragmentNumberString,
  ChannelId,
  KinesisVideoStreamArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class KinesisVideoStreamSourceTaskConfiguration(
    streamArn: KinesisVideoStreamArn,
    channelId: ChannelId,
    fragmentNumber: Optional[FragmentNumberString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration = {
    import KinesisVideoStreamSourceTaskConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
      .builder()
      .streamArn(KinesisVideoStreamArn.unwrap(streamArn): java.lang.String)
      .channelId(ChannelId.unwrap(channelId): Integer)
      .optionallyWith(
        fragmentNumber.map(value =>
          FragmentNumberString.unwrap(value): java.lang.String
        )
      )(_.fragmentNumber)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
      .wrap(buildAwsValue())
}
object KinesisVideoStreamSourceTaskConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration =
      zio.aws.chimesdkmediapipelines.model
        .KinesisVideoStreamSourceTaskConfiguration(
          streamArn,
          channelId,
          fragmentNumber.map(value => value)
        )
    def streamArn: KinesisVideoStreamArn
    def channelId: ChannelId
    def fragmentNumber: Optional[FragmentNumberString]
    def getStreamArn: ZIO[Any, Nothing, KinesisVideoStreamArn] =
      ZIO.succeed(streamArn)
    def getChannelId: ZIO[Any, Nothing, ChannelId] = ZIO.succeed(channelId)
    def getFragmentNumber: ZIO[Any, AwsError, FragmentNumberString] =
      AwsError.unwrapOptionField("fragmentNumber", fragmentNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration.ReadOnly {
    override val streamArn: KinesisVideoStreamArn =
      zio.aws.chimesdkmediapipelines.model.primitives
        .KinesisVideoStreamArn(impl.streamArn())
    override val channelId: ChannelId =
      zio.aws.chimesdkmediapipelines.model.primitives
        .ChannelId(impl.channelId())
    override val fragmentNumber: Optional[FragmentNumberString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fragmentNumber())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .FragmentNumberString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration
  ): zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration.ReadOnly =
    new Wrapper(impl)
}
