package zio.aws.chimesdkmediapipelines.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  DataRetentionInHours,
  AwsRegion
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class KinesisVideoStreamConfiguration(
    region: AwsRegion,
    dataRetentionInHours: Optional[DataRetentionInHours] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration = {
    import KinesisVideoStreamConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration
      .builder()
      .region(AwsRegion.unwrap(region): java.lang.String)
      .optionallyWith(
        dataRetentionInHours.map(value =>
          DataRetentionInHours.unwrap(value): Integer
        )
      )(_.dataRetentionInHours)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration
      .wrap(buildAwsValue())
}
object KinesisVideoStreamConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration =
      zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration(
        region,
        dataRetentionInHours.map(value => value)
      )
    def region: AwsRegion
    def dataRetentionInHours: Optional[DataRetentionInHours]
    def getRegion: ZIO[Any, Nothing, AwsRegion] = ZIO.succeed(region)
    def getDataRetentionInHours: ZIO[Any, AwsError, DataRetentionInHours] =
      AwsError.unwrapOptionField("dataRetentionInHours", dataRetentionInHours)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration
  ) extends zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration.ReadOnly {
    override val region: AwsRegion =
      zio.aws.chimesdkmediapipelines.model.primitives.AwsRegion(impl.region())
    override val dataRetentionInHours: Optional[DataRetentionInHours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataRetentionInHours())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .DataRetentionInHours(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration
  ): zio.aws.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration.ReadOnly =
    new Wrapper(impl)
}
