package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMediaPipelineKinesisVideoStreamPoolRequest(
    identifier: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest = {
    import GetMediaPipelineKinesisVideoStreamPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest
      .wrap(buildAwsValue())
}
object GetMediaPipelineKinesisVideoStreamPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest =
      zio.aws.chimesdkmediapipelines.model
        .GetMediaPipelineKinesisVideoStreamPoolRequest(identifier)
    def identifier: NonEmptyString
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest
  ) extends zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest
  ): zio.aws.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly =
    new Wrapper(impl)
}
