package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMediaPipelineKinesisVideoStreamPoolRequest(
    identifier: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest = {
    import DeleteMediaPipelineKinesisVideoStreamPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest
      .wrap(buildAwsValue())
}
object DeleteMediaPipelineKinesisVideoStreamPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest =
      zio.aws.chimesdkmediapipelines.model
        .DeleteMediaPipelineKinesisVideoStreamPoolRequest(identifier)
    def identifier: NonEmptyString
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest
  ) extends zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest
  ): zio.aws.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest.ReadOnly =
    new Wrapper(impl)
}
