package zio.aws.chimesdkmediapipelines.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.chimesdkmediapipelines.model.primitives.{
  Iso8601Timestamp,
  GuidString
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VoiceToneAnalysisTask(
    voiceToneAnalysisTaskId: Optional[GuidString] = Optional.Absent,
    voiceToneAnalysisTaskStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceToneAnalysisTask = {
    import VoiceToneAnalysisTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceToneAnalysisTask
      .builder()
      .optionallyWith(
        voiceToneAnalysisTaskId.map(value =>
          GuidString.unwrap(value): java.lang.String
        )
      )(_.voiceToneAnalysisTaskId)
      .optionallyWith(voiceToneAnalysisTaskStatus.map(value => value.unwrap))(
        _.voiceToneAnalysisTaskStatus
      )
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask
      .wrap(buildAwsValue())
}
object VoiceToneAnalysisTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceToneAnalysisTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask =
      zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask(
        voiceToneAnalysisTaskId.map(value => value),
        voiceToneAnalysisTaskStatus.map(value => value),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value)
      )
    def voiceToneAnalysisTaskId: Optional[GuidString]
    def voiceToneAnalysisTaskStatus
        : Optional[zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def getVoiceToneAnalysisTaskId: ZIO[Any, AwsError, GuidString] = AwsError
      .unwrapOptionField("voiceToneAnalysisTaskId", voiceToneAnalysisTaskId)
    def getVoiceToneAnalysisTaskStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus
    ] = AwsError.unwrapOptionField(
      "voiceToneAnalysisTaskStatus",
      voiceToneAnalysisTaskStatus
    )
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceToneAnalysisTask
  ) extends zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.ReadOnly {
    override val voiceToneAnalysisTaskId: Optional[GuidString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceToneAnalysisTaskId())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives.GuidString(value)
        )
    override val voiceToneAnalysisTaskStatus: Optional[
      zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceToneAnalysisTaskStatus())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.MediaPipelineTaskStatus.wrap(value)
      )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmediapipelines.model.primitives
            .Iso8601Timestamp(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceToneAnalysisTask
  ): zio.aws.chimesdkmediapipelines.model.VoiceToneAnalysisTask.ReadOnly =
    new Wrapper(impl)
}
