package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters._
sealed trait ResolutionOption {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption
}
object ResolutionOption {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption
  ): zio.aws.chimesdkmediapipelines.model.ResolutionOption = value match {
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption.HD =>
      val r = HD
      r
    case software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption.FHD =>
      val r = FHD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.ResolutionOption {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption.UNKNOWN_TO_SDK_VERSION
  }
  case object HD extends zio.aws.chimesdkmediapipelines.model.ResolutionOption {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption.HD
  }
  case object FHD
      extends zio.aws.chimesdkmediapipelines.model.ResolutionOption {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.ResolutionOption.FHD
  }
}
