package zio.aws.chimesdkmediapipelines.model
import scala.jdk.CollectionConverters._
sealed trait LiveConnectorSourceType {
  def unwrap: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceType
}
object LiveConnectorSourceType {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceType
  ): zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceType =
    value match {
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceType.CHIME_SDK_MEETING =>
        val r = ChimeSdkMeeting
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ChimeSdkMeeting
      extends zio.aws.chimesdkmediapipelines.model.LiveConnectorSourceType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceType =
      software.amazon.awssdk.services.chimesdkmediapipelines.model.LiveConnectorSourceType.CHIME_SDK_MEETING
  }
}
