package zio.aws.chimesdkmediapipelines.model
import zio.ZIO
import zio.aws.chimesdkmediapipelines.model.primitives.{Arn, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateMediaInsightsPipelineConfigurationRequest(
    identifier: NonEmptyString,
    resourceAccessRoleArn: Arn,
    realTimeAlertConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration
    ] = Optional.Absent,
    elements: Iterable[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest = {
    import UpdateMediaInsightsPipelineConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest
      .builder()
      .identifier(NonEmptyString.unwrap(identifier): java.lang.String)
      .resourceAccessRoleArn(
        Arn.unwrap(resourceAccessRoleArn): java.lang.String
      )
      .optionallyWith(
        realTimeAlertConfiguration.map(value => value.buildAwsValue())
      )(_.realTimeAlertConfiguration)
      .elements(elements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest.ReadOnly =
    zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateMediaInsightsPipelineConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest =
      zio.aws.chimesdkmediapipelines.model
        .UpdateMediaInsightsPipelineConfigurationRequest(
          identifier,
          resourceAccessRoleArn,
          realTimeAlertConfiguration.map(value => value.asEditable),
          elements.map { item =>
            item.asEditable
          }
        )
    def identifier: NonEmptyString
    def resourceAccessRoleArn: Arn
    def realTimeAlertConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly
    ]
    def elements: List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly
    ]
    def getIdentifier: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(identifier)
    def getResourceAccessRoleArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(resourceAccessRoleArn)
    def getRealTimeAlertConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "realTimeAlertConfiguration",
      realTimeAlertConfiguration
    )
    def getElements: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly
    ]] = ZIO.succeed(elements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest
  ) extends zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest.ReadOnly {
    override val identifier: NonEmptyString =
      zio.aws.chimesdkmediapipelines.model.primitives
        .NonEmptyString(impl.identifier())
    override val resourceAccessRoleArn: Arn =
      zio.aws.chimesdkmediapipelines.model.primitives
        .Arn(impl.resourceAccessRoleArn())
    override val realTimeAlertConfiguration: Optional[
      zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.realTimeAlertConfiguration())
      .map(value =>
        zio.aws.chimesdkmediapipelines.model.RealTimeAlertConfiguration
          .wrap(value)
      )
    override val elements: List[
      zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.ReadOnly
    ] = impl
      .elements()
      .asScala
      .map { item =>
        zio.aws.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest
  ): zio.aws.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
